﻿<%@ Control Language="C#" %>
<%@ Import Namespace="Kesion.Cache" %>
<%@ Import Namespace="Kesion.Publics" %>
<%@ Import Namespace="Kesion.BLL" %>
<%@ Import Namespace="Kesion.Config" %>
<%@ Import Namespace="Kesion.Components" %>
<%@ Import Namespace="Kesion.HtmlTags" %>
<%@ Import Namespace="Kesion.XML" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.Xml" %>
<%@ Import Namespace="Newtonsoft.Json.Linq" %>

<script runat="server" type="text/C#">

    dynamic __user = HttpContext.Current.Items["user"];                //初始化用户信息
    string sql = string.Empty;//购买考核任务表查询语句

    int recordcount, pagecount;//分页的参数信息
    int pagesize = 10;
    int PageIndex = new BasicField().GetCurrPage;
    public static int roomId = 0;//从班级过来的班级ID
    public static string packids = string.Empty;//考核项目IDs
    public static string roomName = string.Empty;//班级标题
    protected void Page_Load(object sender, EventArgs e)
    {
        roomId = Utils.StrToInt(KSCMS.S("roomid"));
        using (DataTable dtPack = DataFactory.GetDataTable("SELECT TOP 1 packid,Title FROM KS_CosClassRoom WHERE roomid =" + roomId))
        {
            if(dtPack.Rows.Count>0)
            {
                DataRow drPack = dtPack.Rows[0];
                packids = drPack["packid"].ToString();
                roomName = drPack["Title"].ToString();

            }
        }

        sql = " KS_CheckPackageItem where userid=" + __user.UserID; //确定每个用户信息
        string action = KSCMS.S("action");
        if (string.IsNullOrEmpty(action)) { action = KSCMS.S("do"); }
        switch(action)
        {
            case "dobuy"://余额支付
                dobuy();
                break;
        }
    }
    //余额支付信息
    public void dobuy()
    {
        UserInfo __info = UserManage.GetUserInfo();//获取当前用户信息
        string username = UserManage.GetUserInfo().UserName;//获取用户名
        string packid = KSCMS.S("packid");
        if(packid=="0"||string.IsNullOrEmpty(packid))
        {
            Msg.Alert("选择出错，请检查您是否选择了购买项目信息！",KSCMS.GetComeUrl());
            return;
        }
        //先检查考核项目中是否存在选中的项目信息
        using (DataTable dt = DataFactory.GetDataTable("select  *  from KS_CheckPackage where packid in ("+Utils.FilterIDs(packid)+")"))
        {
            if (dt.Rows.Count <= 0)
            {
                Msg.Alert("出错啦，找不到您要购买的项目信息！", KSCMS.GetComeUrl());
                return;
            }
            else
            {
                //string repetitionpackname = string.Empty;//存储重复购买的项目名称
                float money = 0;
                foreach (DataRow dr in dt.Rows)
                {
                    //首先判断购买权限信息
                    if (dr["groupids"].ToString() != "" || !string.IsNullOrEmpty(dr["groupids"].ToString()))
                    {
                        if (Utils.InArray(__info.GroupID.ToString(), dr["groupids"].ToString(), ",") == false)
                        {
                            Msg.Alert("对不起,此项目限制分组购买！", KSCMS.GetComeUrl());
                            return;
                        }
                    }
                    if (dr["Departids"].ToString() != "" || !string.IsNullOrEmpty(dr["Departids"].ToString()))
                    {
                        if (Utils.InArray(__info.DepartID.ToString(), dr["Departids"].ToString(), ",") == false)
                        {
                            Msg.Alert("对不起,此项目限制部门购买！", KSCMS.GetComeUrl());
                            return;
                        }
                    }
                    money += Utils.StrToFloat(dr["sellprice"].ToString());//购买所需要消费总金额
                }
                //首先检查用户余额是否能够购买项目信息
                if (__info.Money < money)
                {
                    //金额不足跳向充值页面
                    Msg.Alert("对不起，您可用金额不足，您选择的项目共需要消费" + money + "元，您当前的可用余额为" + __info.Money + "元，请先充值再来购买！", BasicField.GetUserUrl("basic/PayOnline"));
                    return;
                }
                //由于可以选多个  所以要用循环解决问题
                foreach(DataRow dr in dt.Rows)
                {
                    //int repetitionpackid = 0;//存储重复购买的id信息
                    int checkid = Utils.StrToInt(dr["packid"].ToString());//考核项目的id信息
                    float price = Utils.StrToFloat(dr["sellprice"].ToString(),0);//考核项目的出售价格
                    if (price > 0)
                    {
                        if (Charge.MoneyInOrOut(__info.UserID, __info.RealName, price, 1, 2, checkid.ToString(), "system", "购买考核项目[" + dr["packname"].ToString() + "]!", -501, 0, 1))//-501   购买考核项目的信息
                        {
                            Hashtable ht = new Hashtable();
                            ht.Add("username", __info.UserName);
                            ht.Add("userid", __info.UserID);
                            ht.Add("addtime", DateTime.Now);
                            ht.Add("packid", checkid);//存储考核项目信息
                            ht.Add("price", price);//存储考核项目出售价格信息
                            ht.Add("packname", dr["packname"].ToString());//存储考核项目名称
                            ht.Add("datestatus", Utils.StrToInt(dr["datestatus"]));
                            if (Utils.StrToInt(dr["datestatus"]) == 1)
                            {
                                ht.Add("startdate", dr["startdate"].ToString());
                                ht.Add("enddate", dr["enddate"].ToString());
                            }
                            try
                            {
                                if (!DataFactory.Exists("KS_CheckPackageItem", "packid="+checkid+" and userid="+ __user.UserID))
                                {
                                    CommonData.Insert("KS_CheckPackageItem", ht);//明细表增加信息
                                }
                                Kesion.Course.CourseUserPowerCache.CleanPackageJson(__info.UserID);  //清除考核包JSON缓存
                                Msg.Alert("恭喜，购买考核项目成功！", BasicField.GetUserUrl("course/MyAssessment"));
                            }
                            catch
                            {
                                Msg.Alert("购买考核项目失败！", KSCMS.GetComeUrl());
                                return;
                            }
                        }
                        else
                        {
                            Msg.Alert("购买考核项目失败！", KSCMS.GetComeUrl());
                            return;
                        }
                    }
                    else {
                        //免费直接进行记录增加
                        Hashtable ht = new Hashtable();
                        ht.Add("username", __info.UserName);
                        ht.Add("userid", __info.UserID);
                        ht.Add("addtime", DateTime.Now);
                        ht.Add("packid", checkid);//存储考核项目信息
                        ht.Add("price", price);//存储考核项目出售价格信息
                        ht.Add("packname", dr["packname"].ToString());//存储考核项目名称
                        ht.Add("datestatus", Utils.StrToInt(dr["datestatus"]));
                        if (Utils.StrToInt(dr["datestatus"]) == 1)
                        {
                            ht.Add("startdate",dr["startdate"].ToString());
                            ht.Add("enddate", dr["enddate"].ToString());
                        }
                        try
                        {
                            if (!DataFactory.Exists("KS_CheckPackageItem", "packid="+checkid+" and userid="+ __user.UserID))
                            {
                                CommonData.Insert("KS_CheckPackageItem", ht);//明细表增加信息
                            }
                            Kesion.Course.CourseUserPowerCache.CleanPackageJson(__info.UserID);  //清除考核包JSON缓存
                            Msg.Alert("恭喜，购买考核项目成功！共从余额中扣除" + money+"元", BasicField.GetUserUrl("course/MyAssessment"));
                            return;
                        }
                        catch
                        {
                            Msg.Alert("购买考核项目失败！", KSCMS.GetComeUrl());
                            return;
                        }
                    }
                }
            }
        }
    }
    #region  获取相关信息条件
    //获取学完的课程数量
    public string GetCheckInfoMsg(int datestatus, DateTime start, DateTime end,int packid)
    {
        string Msg = string.Empty;
        if (datestatus == 1)
        {
            if (DateTime.Now < end && DateTime.Now > start)
            {
                Msg = "location.href='" + BasicField.GetUserUrl("course/MyCheckpackageInfo", "packid-" + packid)+"'";
            }
            else {
                Msg = "alert('该考核项目暂未开始或已结束！请联系管理员咨询相关信息！')";
            }
        }
        else {
            Msg = "location.href='" + BasicField.GetUserUrl("course/MyCheckpackageInfo", "packid-" + packid)+"'";
        }
        return Msg;
    }
    //获取考核项目的时间限制
    public string getpacktime(int datestatus, string start, string end)
    {
        if (datestatus == 1)
        {
            return Convert.ToDateTime(start).ToString("yyyy-MM-dd") + "至" + Convert.ToDateTime(end).ToString("yyyy-MM-dd");
        }
        else
        {
            return "无限制";
        }
    }
    //购买状态信息
    public int showorhide(int packid)
    {
        int count = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) from KS_CheckPackageItem where userid=" + __user.UserID + " and packid =" + packid),0);
        if (count > 0)
        {
            return 1;//已购买
        }
        else
        {
            return 0;//未购买
        }
    }
    //获取价格信息
    public string getpackageprice(string price)
    {
        string pakeprice = string.Empty;
        if (Utils.StrToDecimal(price)>0)
        {
            pakeprice = MyCache.GetCurrencySymbol + Kesion.APPCode.Public.ReturnShopPrice(price) + MyCache.GetCurrencyUnit;
            return pakeprice;
        }
        else {
            pakeprice = "免费参与";
            return pakeprice;
        }
    }
    //获取限制分组信息
    public string getlimtgroup(string groupids)
    {
        string groupname = string.Empty;
        using (DataTable dt = DataFactory.GetDataTable("select groupname from KS_UserGroup where groupid in (" + Utils.FilterIDs(groupids) + ")"))
        {
            if (dt.Rows.Count > 0) {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(groupname))
                    {
                        groupname ="限制分组信息："+ dr[0].ToString();
                    }
                    else {
                        groupname += ","+dr[0].ToString();
                    }
                }
            } else
            {
                groupname = "分组无限制";
            }
        }
        return  groupname ;
    }
    //获取限制部门信息
    public string getlimtdepart(string departids)
    {
        string groupname = string.Empty;
        using (DataTable dt = DataFactory.GetDataTable("select departmentname from KS_UserDepartment where departid in (" + Utils.FilterIDs(departids) + ")"))
        {
            if (dt.Rows.Count > 0)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (string.IsNullOrEmpty(groupname))
                    {
                        groupname = "限制部门信息：" + dr[0].ToString();
                    }
                    else
                    {
                        groupname += "," + dr[0].ToString();
                    }
                }
            }
            else
            {
                groupname = "部门无限制";
            }
        }
        return groupname;
    }
    //获取考核学习包内的课程试卷数量
    public string getcheckInfo(int packid)
    {
        StringBuilder sb = new StringBuilder();
        string courseall = DataFactory.GetOnlyValue("select count(1) from KS_CheckPackinfo where type=0 and packid=" + packid);//所有课程
        string mustcourse = DataFactory.GetOnlyValue("select count(1) from KS_CheckPackinfo where type=0 and isorno=1 and packid=" + packid);//必选课程
        string sjall = DataFactory.GetOnlyValue("select count(1) from KS_CheckPackinfo where type=1 and packid=" + packid);//所有试卷
        string mustsj = DataFactory.GetOnlyValue("select count(1) from KS_CheckPackinfo where type=1 and isorno=1 and packid=" + packid);//必选试卷
        sb.AppendFormat(@"<span class=""coursenum"" data-num=""{0}"">{0}门课程（必修{1}）</span>", courseall, mustcourse);
        if (Utils.StrToInt(sjall) > 0)
        {
            sb.AppendFormat(@" <span  class=""examnum"" data-num=""{0}"">{0}份试卷（必修{1}）</span>", sjall, mustsj);
        }
        else{
            sb.AppendFormat(@" <span style=""display:none;"" class=""examnum"" data-num=""{0}""></span>", sjall);
        }
        return sb.ToString();
    }
    //获取学习进度信息
    public string getstudyinfo(int packid)
    {
        StringBuilder sb = new StringBuilder();
        string courseid = DataFactory.GetOnlyValue("select studycourse from KS_CheckPackageItem where userid=" + __user.UserID + " and packid="+packid); //首先查询用户购买的包信息
        string sjids = DataFactory.GetOnlyValue("select Studysj from KS_CheckPackageItem where userid=" + __user.UserID + " and packid=" + packid);//获取已学习的试卷信息
        int coursecount = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) from KS_Course where courseid in ("+Utils.FilterIDs(courseid)+")"));//获取已学习课程的数量
        int sjcount = Utils.StrToInt(DataFactory.GetOnlyValue("select count(1) from Ks_Sj where id in (" + Utils.FilterIDs(sjids) + ")"));//获取已得试卷数量

        sb.AppendFormat(@" <div class=""cos-progress"" data-num=""{0}""></div>", coursecount);
        sb.AppendFormat(@" <div class=""exam-progress"" data-num=""{0}""></div>", sjcount);

        return sb.ToString();
    }
    //获取考核包的总分
    public string getpackScore(int packid)
    {
        string score = DataFactory.GetOnlyValue("select score from KS_CheckPackage where packid ="+packid);
        return score;
    }
    //获取考核通过的分数信息
    public string getpassscore(int packid)
    {
        string passscore = DataFactory.GetOnlyValue("select passscore from KS_CheckPackage where packid =" + packid);
        return passscore;
    }

    #endregion
</script>
<div class="r_tybox nomar">
    <script>
        //弹窗
        function openWin(title, url, reload, width, height) {
            if (width == null) width = 760;
            if (height == null) height = 450;
            isreload = reload;
            box = $.dialog.open(url, {
                id: 'topbox', lock: true, title: title, width: width, height: height, close: function () {
                    if (isreload) {
                        location.reload();
                    }
                }
            });
        }
        //获取复选框中的信息  前台校验
        function GetMyIds() {
            var sid = null;
            for (var i = 0; i < document.getElementsByName("packid").length; i++) {
                var KS = document.getElementsByName("packid")[i];
                if (KS.checked == true) {
                    if (sid == null)
                        sid = KS.value;
                    else
                        sid += "|" + KS.value;
                }
            }
            return sid;
        }
        //简单校验信息
        function check()
        {
            var sid = GetMyIds();
            if (sid == null)
            {
                KesionJS.Alert("请先需要购买的项目信息！");
                return false;
            }
            if(confirm('此操作不可逆！确定购买么？')){
                $("#action").val("dobuy");
                return true;
            }else{
                return false;
            }
        }
    </script>
     <div class="r_title"><h4 class="disting-title disting_show"><%=roomId==0?"":roomName+"-"%>我的考核</h4></div>
    	
    <%if (roomId ==0)
        { %>
     <div class="top-sort clearfix">
        <div class="top-sort-tab lf">
            <ul>  
                <li <%if (BasicField.GetParam("show") == "") Response.Write(" class='puton'"); %>><a href="<%=BasicField.GetUserUrl("course/MyAssessment") %>">我的考核项目</a></li>
                <li <%if (BasicField.GetParam("show") == "1") Response.Write(" class='puton'"); %>><a href="<%=BasicField.GetUserUrl("course/MyAssessment", "show-1") %>">购买考核项目</a></li>
                <li <%if (BasicField.GetParam("show") == "2") Response.Write(" class='puton'"); %>><a href="<%=BasicField.GetUserUrl("course/MyAssessment", "show-2") %>">购买明细</a></li>
            </ul>
        </div>
       
    </div>
    <%} %>

    <div class="r_tablebox">
        <%if(KSCMS.S("show")==""){ %>
        <table width="100%" cellpadding="0" cellspacing="0" class="border">
            <tr class="title">
                <td>项目名称</td>
                <td>学习进度</td>
                <td>考核总分</td>
                <td>通过分数</td>
                <td>已得分数</td>
                <td>时间</td>
                <td>操作</td>
            </tr>
        
       
                <%  
                    if (roomId!=0)
                    {
                       
                        sql += " AND packid IN("+Utils.FilterIDs(packids)+")";

                    }
                    using (DataTable dt = DataFactory.GetPage("*", sql, "orderid", "order by  orderid  desc", PageIndex, pagesize, out recordcount, out pagecount))
                    {
                        if (dt.Rows.Count > 0)
                        {
                            foreach (DataRow dr in dt.Rows)
                            {
                            %>
                <tr>
                    <td class="tag_left"><strong><%=dr["Packname"].ToString()%></strong><p class="p-sub-info"><%=getcheckInfo(Utils.StrToInt(dr["packid"].ToString())) %></p></td>
                    
                    <td>
                    <%=getstudyinfo(Utils.StrToInt(dr["packid"].ToString())) %> 
                    </td>
                    <td><%=getpackScore(Utils.StrToInt(dr["packid"].ToString())) %></td>
                    <td><%=getpassscore(Utils.StrToInt(dr["packid"].ToString())) %></td>
                    <td><%=dr["score"].ToString() %></td>
                    <td><%=getpacktime(Utils.StrToInt(dr["datestatus"].ToString()),dr["startdate"].ToString(),dr["enddate"].ToString()) %></td>
                    <td>
                        <a class="green-bt bt-auto" href="javascript:;" onclick="<%=GetCheckInfoMsg(Utils.StrToInt(dr["datestatus"].ToString()),Utils.StrToDateTime(dr["startdate"].ToString()),Utils.StrToDateTime(dr["enddate"].ToString()),Utils.StrToInt(dr["packid"].ToString())) %>">查看详情</a>
                    </td>
                </tr>
                  <%
                        }
                    }
                    else {
                        KSCMS.W(@"<tr class=""tr-nobor""><td colspan=""10""><div class=""empty"">
                                        暂时没有您参与考核项目的信息
                                  </div></td><tr><style>.cz_btn{display:none;}</style>");
                    }
                }
                 %>

            </table>


            <script>
                $('.cos-progress').each(function(){
                    var num = $(this).attr('data-num');
                    var maxNum = $(this).parent().prev().find('.coursenum').attr('data-num');
                    //计算进度
                    var pro = num/maxNum*100;
                    $(this).append('<span>'+num+'/'+maxNum+'</span><i class="lined" style="width:'+pro+'%"></i><i class="line"></i>');
                    var spanWidth = $(this).find('span').width()+10;
                    $(this).find('span').css({right:'-'+spanWidth+'px'});
                });
                $('.exam-progress').each(function(){
                    var num = $(this).attr('data-num');
                    var maxNum = $(this).parent().prev().find('.examnum').attr('data-num');
                    //计算进度
                    var pro = num/maxNum*100;
                    $(this).append('<span>'+num+'/'+maxNum+'</span><i class="lined" style="width:'+pro+'%"></i><i class="line"></i>');
                    var spanWidth = $(this).find('span').width()+10;
                    $(this).find('span').css({right:'-'+spanWidth+'px'});
                });
            </script>

            
            <div class="cz_btn">
                <div class="color-tips">
                    <span><i class="green"></i>课程</span>
                    <span><i class="blue"></i>试卷</span>
                </div>
              
            </div>
            <div class="fy_box">
                  <%
                    #region 分页
                    string PageStr = "[KS:PageStr2]";
                    BasicField.ReplaceFilterPage(ref PageStr, PageIndex, pagesize, pagecount, recordcount);
                    KSCMS.W(PageStr);
                    #endregion
                  %>
              </div>

        <%} if(KSCMS.S("show") == "1"){ %>
        <form action="{$GetCurrUrl}" method="post">
            <script>
				$(".table-tr:even").css("background-color","#f9f9f9");
                function checkbuy(money,url)
				{
                    if (url != "") {
                        if (confirm('确定购买本考核项目么？从当前余额中扣除' + money + '元')) {
                            location.href = url;
                            return true;
                        } else {
                            return false;
                        }
                    } else { return false; }
                }
            </script>
                <input type="hidden" name="action" id="action" value="action" />
                
                <table width="100%" cellpadding="0" cellspacing="0" class="border">
                    <tr class="title">
                        <td>项目名称</td>
                        <td>购买限制</td>
                        <td nowrap>时间限制</td>
                        <td>上架时间</td>
                        <td>价值</td>
                        <td>操作</td>
                    </tr>

                    <% 
                string pakesql = " KS_CheckPackage where status=1 ";//审核过的显示
                using (DataTable dt = DataFactory.GetPage("*", pakesql, "packid", "order by  packid  desc", PageIndex, pagesize, out recordcount, out pagecount))
                {
                    if (dt.Rows.Count > 0)
                    {
                        foreach (DataRow dr in dt.Rows)
                        {
                            %>
                <tr>
                    <td class="tag_left"><strong><%=dr["Packname"]%></strong><p class="p-sub-info"><%=getcheckInfo(Utils.StrToInt(dr["packid"].ToString())) %> </p></td>
                    
                    <td>
                        <div><%=getlimtgroup(dr["groupids"].ToString()) %></div>
                        <div><%=getlimtdepart(dr["Departids"].ToString()) %></div>
                    </td>
                    <td><%=getpacktime(Utils.StrToInt(dr["datestatus"].ToString()),dr["startdate"].ToString(),dr["enddate"].ToString()) %></td>
                    <td><%= Utils.StrToDateTime(dr["addtime"])%></td>
                    <td><%=Kesion.APPCode.Public.ReturnShopPrice(dr["sellprice"])%>元</td>
                    <td>
                        <a class="green-bt" href="javascript:;"  onclick="checkbuy('<%=Kesion.APPCode.Public.ReturnShopPrice(dr["sellprice"]) %>','<%=(showorhide(Utils.StrToInt(dr["packid"]))==1?"":BasicField.GetUserUrl("course/MyAssessment","do-dobuy,packid-"+dr["packid"]))%>');" ><%=(showorhide(Utils.StrToInt(dr["packid"]))==1?"已购买":"购买") %></a>
                        <a class="grey-bt mp_10" href="javascript:;"  onclick="openWin('<%=dr["Packname"]%>详情','/plus/course/lookcheckinfo.aspx?packid=<%=dr["packid"]%>',true,900,500)" >查看详情</a>
                        
                    </td>
                </tr>
                      <%          }
                    }
                    else {
                        KSCMS.W(@"<tr><td><div class=""empty"">
                                        暂时没有可购买的考核项目，请等待管理员的添加！
                                  </div></td></tr>");
                    }
                }
                 %> 
                </table>
             
            </form>
        
        <div class="cz_btn">
          <%
            #region 分页
            string PageStr = "[KS:PageStr2]";
            BasicField.ReplaceFilterPage(ref PageStr, PageIndex, pagesize, pagecount, recordcount);
            KSCMS.W(PageStr);
            #endregion
          %>
        </div>
 

        <%} if(KSCMS.S("show")=="2"){ %>

        <table id="tablist" width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="border">
      <tr align="center" class="title">
        	<td>序号</td>
        	<td width="45%">项目名称</td> 
		    <td>时间限制</td>
		    <td>购买日期</td>
            <td>价格</td>

        </tr>
            <%
            int recordcount2, pagecount2;//分页的参数信息
            int pagesize2 = 5;
            int PageIndex2 = new BasicField().GetCurrPage;

            using (DataTable dt = DataFactory.GetPage("*", sql, "orderid", "order by  orderid  desc", PageIndex2, pagesize2, out recordcount2, out pagecount2))
            {
                if (dt.Rows.Count > 0)
                {
                    int i = 0;
                    foreach (DataRow dr in dt.Rows)
                    {
                        %>
            <tr>
                <td class="splittd" style="text-align:center"><%=i+1 %></td>
                <td class="splittd" style="text-align:left"><%=dr["packname"].ToString() %></td>
                <td class="splittd" style="text-align:center"><%=getpacktime(Utils.StrToInt(dr["datestatus"].ToString()),dr["startdate"].ToString(),dr["enddate"].ToString()) %></td>
                <td class="splittd" style="text-align:center"><%=dr["addtime"].ToString() %></td>
                <td class="splittd" style="text-align:center"><%=getpackageprice(dr["price"].ToString()) %></td>
            </tr>
            <%
                        i++;
                    }
                }
                else {
                    KSCMS.S(@"<tr><td colspan='5'><div class=""empty"">
                                        暂时没有您参与考核项目的信息
                                  </div></td></tr>");
                }
            }
                 %>
        </table>
        
        <div class="cz_btn">
          <%
            #region 分页
            string PageStr2 = "[KS:PageStr2]";
            BasicField.ReplaceFilterPage(ref PageStr2, PageIndex2, pagesize2, pagecount2, recordcount2);
            KSCMS.W(PageStr2);
            #endregion
          %>
        </div>

        <%} %>
    </div>
</div>





